#! /usr/bin/python

"""
A collector for the log messages generated by (possibly distributed) OpenQuake
jobs.

The collected messages will be logged by the "collector" logger, as configured
in logging.cfg
"""

import os

import logging
import logging.config

import oqpath
oqpath.set_oq_path()

import openquake
from openquake import signalling


def main():
    logging.config.fileConfig(os.path.join(openquake.OPENQUAKE_ROOT,
                                           'logging.cfg'))

    # any job
    collector = signalling.Collector('*', logging.getLogger('collector'))

    collector.run()


if __name__ == '__main__':
    main()
